$(function() {
    var isRtl =
        $("body").attr("dir") === "rtl" || $("html").attr("dir") === "rtl";

    var table = $("#user-lists").dataTable({
        processing: true,
        serverSide: true,
        info: true,
        lengthChange: false,
        pageLength:10,
        ordering: true,
        order: [[1, "asc"]],
        exportable: true,
        language: {
            emptyTable: "Nema dostupnih podataka u ovoj tablici",
            info: "Prikazano _START_ to _END_ od _TOTAL_ zapisa",
            infoEmpty: "Prikazano 0 to 0 of 0 zapisa",
            infoFiltered: "(filtrirano od _MAX_ ukupnih zapisa)",
            infoPostFix: "",
            thousands: ",",
            lengthMenu: "Prikaži _MENU_ zapisa",
            loadingRecords: "Učitavanje...",
            processing: "Izvršavanje...",
            search: "Pretraga:",
            zeroRecords: "Nije pronađen nijedan zapis",
            paginate: {
                first: "Početak",
                last: "Kraj",
                next: "Sljedeća",
                previous: "Nazad"
            }
        },
        ajax: "korisnici",
        columns: [
            {
                data: "username",
                name: "username",
                title: "Korisničko ime",
                visible: false
            },
            {
                data: "name",
                name: "name",
                title: "Ime i prezime"
            },
            {
                data: "username",
                name: "username",
                title: "Korisničko ime"
            },
            {
                data: "email",
                name: "email",
                title: "Email"
            },
            {
                data: "role",
                name: "role",
                title: "Korisnička uloga/e"
            },
            {
                width: "120px",
                data: "action",
                name: "action",
                title: "Ažuriraj/Izbriši",
                orderable: false
            }
        ],
        createdRow: function(row, data, index) {
            // *********************************************************************


            $("td", row)
                .eq(0)
                .addClass("align-middle");

            $("td", row)
                .eq(1)
                .addClass("align-middle");

            $("td", row)
                .eq(2)
                .addClass("align-middle");

            $("td", row)
                .eq(3)
                .addClass("align-middle");
            //
            // Actions - vidjeti kako uklopiti sa vidljivostima kolona
            /*
            $("td", row)
                .eq(4)
                .addClass("align-middle text-right ")
                .html("")
                .append(
                    '<a href="korisnici/' +
                        data.id +
                        '/uredi" class="btn btn-success" title="Uređivanje korisnika"><i class="pe-7s-edit" title="Uredi"></i></a>&nbsp;&nbsp;' +
                        '<a href="" data-id="' +
                        data.id +
                        '" data-name="' +
                        data.name +
                        '" class="btn btn-danger user-tooltip delete_user" data-toggle="modal" data-target="#delete_user" title="Brisanje korisnika"><i class="pe-7s-trash"></i></a>'
                );
                */
        }
    });


    $('#search').keyup(function(){
        table.search($(this).val()).draw();
      });
  
    // SET INITAL VALUE FOR PAGE
    $('#length_change').val(table.page.len());

    // Function change
    $('#length_change').change(function(){
        table.page.len($(this).val()).draw();
    });
});
