$(function() {
    var isRtl =
        $("body").attr("dir") === "rtl" || $("html").attr("dir") === "rtl";

    var table = $("#solded-list").DataTable({
        processing: true,
        serverSide: true,
        info: true,
        ordering: false,
        lengthChange: false,
        pageLength:10,
        order: [[1, "asc"]],
        exportable: true,
        language: {
            emptyTable: "Nema dostupnih podataka u ovoj tablici",
            info: "Prikazano _START_ to _END_ od _TOTAL_ zapisa",
            infoEmpty: "Prikazano 0 to 0 of 0 zapisa",
            infoFiltered: "(filtrirano od _MAX_ ukupnih zapisa)",
            infoPostFix: "",
            thousands: ",",
            lengthMenu: "Prikaži _MENU_ zapisa",
            loadingRecords: "Učitavanje...",
            processing: "Izvršavanje...",
            search: "Pretraga:",
            zeroRecords: "Nije pronađen nijedan zapis",
            paginate: {
                first: "Početak",
                last: "Kraj",
                next: "Sljedeća",
                previous: "Nazad"
            }
        },
        //ajax: "spareparts/data",
        ajax: {
            
            url: "spareparts/soldedData",
            data: function(d){
                d.car_id = $('select[name=car_id]').val();
                d.cat_id = $('select[name=cat_id]').val();
                d.dcar_id = $('select[name=dcar_id]').val();
                if($('#isBooked').prop('checked')){
                    d.isBooked = 1;
                }else{
                    d.isBooked = 0;
                }
            }
        },
        columns: [
            {
                width: "25px",
                data: "id",
                name: "id",
                title: '',
                orderable: false
            },
            {
                data: "Brend",
                name: "cars.Brend",
                title: "Marka"
            },
            {
                data: "Model",
                name: "Model",
                title: "Model"
            },
            {
                data: "year",
                name: "year",
                title: "Godina"
            },
            {
                data: "sifra",
                name: "damagedcars.sifra",
                title: "Skinuto sa vozila"
            },
            {
                data: 'Name', 
                name: 'spareparts.Name',
                title: 'Naziv'
            },
            {
                data: "CodeName",
                name: "CodeName",
                title: "Kod"
            },
            {
                data: "category_name",
                name: "categories.category_name",
                title: "Kategorija"
            },
            {
                data: 'sale_date', 
                name: 'spareparts.sale_date', 
                title: 'Datum prodaje'
            },
            {
                data: "param_list",
                name: "param_list",
                title: "Parametri",
                visible:false
            }
        ],
        createdRow: function(row, data, index) {
            // *********************************************************************
            $("td", row)
                .eq(0)
                .addClass("align-middle")
                .html("")
                .append(
                    '<a href="dijelovi/'+
                    data.id    +
                    '" class=""><i class="fa fa-search"></i></a>'
                );

            $("td", row)
                .eq(1)
                .addClass("align-middle");

            $("td", row)
                .eq(2)
                .addClass("align-middle");
            
            $("td", row)
                .eq(3)
                .addClass("align-middle");

            $("td", row)
                .eq(4)
                .addClass("align-middle");

            $("td", row)
                .eq(5)
                .addClass("align-middle");

            $("td", row)
                .eq(6)
                .addClass("align-middle");

            $("td", row)
                .eq(7)
                .addClass("align-middle");

            $("td", row)
                .eq(8)
                .addClass("align-middle");

            $("td", row)
                .eq(9)
                .addClass("align-middle");

            $("td", row)
                .eq(10)
                .addClass("align-middle");

            $("td", row)
                .eq(11)
                .addClass("align-middle");

            $("td", row)
                .eq(12)
                .addClass("align-middle");

            $("td", row)
                .eq(13)
                .addClass("align-middle");

            
        },
        initComplete: function(settings, json){
            this.api().columns([1,4,7]).every(function(){
                var column = this;
                /*
                var input = document.createElement("input");
                
                $(input).appendTo($(column.footer()).empty())
                .on('keyup',function(){
                    column.search($(this).val(),false,false,true).draw();
                });
                
                var select = $('<select class="form-control"><option value=""></option></select>')
                .on('change',function(){
                    var val = $(this).val();
                    column.search(this.value).draw();
                });

                 */

                // Use column title for label text
                var title = $(column.footer()).text();

            
                 // GENERATE SELECT
                var select = $('<select class="form-control"><option value=""></option></select>')
                .appendTo($(column.footer()).empty())
                .on('change',function(){
                    var val = $(this).val();
                    column.search(this.value).draw();
                });

                // Capture the data from the JSON to populate the select boxes with all the options
                var extraData = (function(i){
                    switch(i){
                        case 1:
                            return json.allCars;
                        case 4:
                            return json.allDamagedcars;
                        case 7:
                            return json.allCategories;
                    }
                })(column.index());
               
                // Draw select options
                extraData.forEach(function(d){
                    if(column.search()===d){
                        select.append('<option value="'+d+'" selected="selected">'+d+'</option>')
                    }
                    else{
                        select.append('<option value="'+d+'">'+d+'</option>')
                    }
                });
              
                

                
    
            });
            
        }

    });

    $('#search').keyup(function(){
        table.search($(this).val()).draw();
    });

    // SET INITAL VALUE FOR PAGE
    $('#length_change').val(table.page.len());

    // Function change
    $('#length_change').change(function(){
        table.page.len($(this).val()).draw();
    });

    
    $('#cars2').change(function(){
        table.draw();
    });

    $('#categories2').change(function(){
        table.draw();
    });

    $('#damagedcars2').change(function(){
        table.draw();
    });

    $("#isBooked").change(function(){
        table.draw();
    });
});
