$(function () {

    var table = $("#logs-list").DataTable({
       processing: true,
       serverSide: true,
       info: true,
       ordering: false,
       lengthChange: false,
       pageLength:10,
       order: [[1, "asc"]],
       exportable: true,
       language: {
         emptyTable: "Nema dostupnih podataka u ovoj tablici",
         info: "Prikazano _START_ to _END_ od _TOTAL_ zapisa",
         infoEmpty: "Prikazano 0 to 0 of 0 zapisa",
         infoFiltered: "(filtrirano od _MAX_ ukupnih zapisa)",
         infoPostFix: "",
         thousands: ",",
         lengthMenu: "Prikaži _MENU_ zapisa",
         loadingRecords: "Učitavanje...",
         processing: "Izvršavanje...",
         search: "Pretraga:",
         zeroRecords: "Nije pronađen nijedan zapis",
         paginate: {
           first: "Početak",
           last: "Kraj",
           next: "Sljedeća",
           previous: "Nazad",
         },
       },
       ajax: "aktivnosti",
       columns: [
         {
           data: "created_at",
           name: "created_at",
           title: "VRIJEME",
         },
         {
            data: "message",
            name: "message",
            title: "OPIS",
          },
          {
            data: "name",
            name: "users.name",
            title: "KORISNIK",
          },
         
       ],
       createdRow: function (row, data, index) {
         // *********************************************************************
         $("td", row)
           .eq(0)
           .addClass("align-middle")
           ;
   
         $("td", row)
           .eq(1)
           .addClass("align-middle")
           ;

        $("td", row)
           .eq(2)
           .addClass("align-middle")
           ;
       },
     });
     
     $('#search').keyup(function(){
       table.search($(this).val()).draw();
     });
 
     // SET INITAL VALUE FOR PAGE
     $('#length_change').val(table.page.len());
 
     // Function change
     $('#length_change').change(function(){
       table.page.len($(this).val()).draw();
     });
 });
   