$(function() {
    var isRtl =
        $("body").attr("dir") === "rtl" || $("html").attr("dir") === "rtl";

    var table = $("#damagedcars-list").DataTable({
        processing: true,
        serverSide: true,
        info: true,
        ordering: false,
        lengthChange: false,
        pageLength:10,
        order: [[1, "asc"]],
        exportable: true,
        language: {
            emptyTable: "Nema dostupnih podataka u ovoj tablici",
            info: "Prikazano _START_ to _END_ od _TOTAL_ zapisa",
            infoEmpty: "Prikazano 0 to 0 of 0 zapisa",
            infoFiltered: "(filtrirano od _MAX_ ukupnih zapisa)",
            infoPostFix: "",
            thousands: ",",
            lengthMenu: "Prikaži _MENU_ zapisa",
            loadingRecords: "Učitavanje...",
            processing: "Izvršavanje...",
            search: "Pretraga:",
            zeroRecords: "Nije pronađen nijedan zapis",
            paginate: {
                first: "Početak",
                last: "Kraj",
                next: "Sljedeća",
                previous: "Nazad"
            }
        },
        ajax: "rastavljenavozila",
        columns: [
            {
                width: "25px",
                data: "id",
                name: "id",
                title: '',
                orderable: false
            },
            {
                data: "sifra",
                name: "sifra",
                title: "Šifra"
            },
            {
                data: "Brend",
                name: "cars.Brend",
                title: "Marka"
            },
            {
                data: "model",
                name: "model",
                title: "Model"
            },
            {
                data: "godina",
                name: "godina",
                title: "Godina"
            },
            {
                data: "kubika",
                name: "kubika",
                title: "Kubika"
            },
            {
                data: "kilovat",
                name: "kilovat",
                title: "Kilowati"
            },
            {
                data: "kilometri",
                name: "kilometri",
                title: "Kilometraža"
            },
            {
                data: "gorivo",
                name: "gorivo",
                title: "Gorivo"
            },
            {
                data: "brojs_sasije",
                name: "brojs_sasije",
                title: "Broj šasije"
            },
            {
                data: "broj_motora",
                name: "broj_motora",
                title: "Broj motora"
            }
        ],
        createdRow: function(row, data, index) {
            // *********************************************************************
            $("td", row)
                .eq(0)
                .addClass("align-middle")
                .html("")
                .append(
                    '<a href="rastavljenavozila/'+
                    data.id    +
                    '" class=""><i class="fa fa-search"></i></a>'
                );

            $("td", row)
                .eq(1)
                .addClass("align-middle");

            $("td", row)
                .eq(2)
                .addClass("align-middle");
            
            $("td", row)
                .eq(3)
                .addClass("align-middle");

            $("td", row)
                .eq(4)
                .addClass("align-middle");

            $("td", row)
                .eq(5)
                .addClass("align-middle");

            $("td", row)
                .eq(6)
                .addClass("align-middle");

            $("td", row)
                .eq(7)
                .addClass("align-middle");

            $("td", row)
                .eq(8)
                .addClass("align-middle");

            $("td", row)
                .eq(9)
                .addClass("align-middle");

            $("td", row)
                .eq(10)
                .addClass("align-middle");

            $("td", row)
                .eq(11)
                .addClass("align-middle");

            $("td", row)
                .eq(12)
                .addClass("align-middle");

            $("td", row)
                .eq(13)
                .addClass("align-middle");

            
        }
    });

    $('#search').keyup(function(){
        table.search($(this).val()).draw();
    });

    // SET INITAL VALUE FOR PAGE
    $('#length_change').val(table.page.len());

    // Function change
    $('#length_change').change(function(){
        table.page.len($(this).val()).draw();
    });
});
