$(function() {
    var isRtl =
        $("body").attr("dir") === "rtl" || $("html").attr("dir") === "rtl";

    var table = $("#categories-list").DataTable({
        processing: true,
        serverSide: true,
        info: true,
        ordering: false,
        lengthChange: false,
        pageLength:10,
        order: [[1, "asc"]],
        exportable: true,
        language: {
            emptyTable: "Nema dostupnih podataka u ovoj tablici",
            info: "Prikazano _START_ to _END_ od _TOTAL_ zapisa",
            infoEmpty: "Prikazano 0 to 0 of 0 zapisa",
            infoFiltered: "(filtrirano od _MAX_ ukupnih zapisa)",
            infoPostFix: "",
            thousands: ",",
            lengthMenu: "Prikaži _MENU_ zapisa",
            loadingRecords: "Učitavanje...",
            processing: "Izvršavanje...",
            search: "Pretraga:",
            zeroRecords: "Nije pronađen nijedan zapis",
            paginate: {
                first: "Početak",
                last: "Kraj",
                next: "Sljedeća",
                previous: "Nazad"
            }
        },
        ajax: "kategorije",
        columns: [
            {
                data: "category_name",
                name: "category_name",
                title: "Naziv kategorije"
            },
            {
                data: "ShortName",
                name: "ShortName",
                title: "Kratki naziv"
            },
            {
                data: "saas_name",
                name: "saas_name",
                title: "OLXID"
            },
            {
                width: "150px",
                data: "action",
                name: "action",
                title: "",
                orderable: false
            }
        ],
        createdRow: function(row, data, index) {
            // *********************************************************************
            $("td", row)
                .eq(0)
                .addClass("align-middle");

            $("td", row)
                .eq(1)
                .addClass("align-middle");
            
            $("td", row)
                .eq(2)
                .addClass("align-middle");

            // Actions
            $("td", row)
                .eq(3)
                .addClass("text-right text-nowrap")
                .html("")
                .append(

                    '<a href="kategorije/' +
                    data.id +
                    '" class="btn btn-success user-tooltip" title="Uređivanje kategorije"><i class="pe-7s-edit" title="Uredi"></i></a>&nbsp;&nbsp;' +
                    '<a href="" data-id="' +
                        data.id +
                        '" data-name="' +
                        data.category_name +
                        '" class="btn btn-danger user-tooltip delete_category" data-toggle="modal" data-target="#delete_category" title="Brisanje kategorije"><i class="pe-7s-trash"></i></a>'
                );
        }
    });
    
    $('#search').keyup(function(){
        table.search($(this).val()).draw();
      });
  
      // SET INITAL VALUE FOR PAGE
      $('#length_change').val(table.page.len());
  
      // Function change
      $('#length_change').change(function(){
        table.page.len($(this).val()).draw();
      });
});
