$(function () {

    $("#cars-list").DataTable({
      processing: true,
      serverSide: true,
      info: true,
      ordering: false,
      lengthChange: false,
      order: [[1, "asc"]],
      exportable: true,
      language: {
        emptyTable: "Nema dostupnih podataka u ovoj tablici",
        info: "Prikazano _START_ to _END_ od _TOTAL_ zapisa",
        infoEmpty: "Prikazano 0 to 0 of 0 zapisa",
        infoFiltered: "(filtrirano od _MAX_ ukupnih zapisa)",
        infoPostFix: "",
        thousands: ",",
        lengthMenu: "Prikaži _MENU_ zapisa",
        loadingRecords: "Učitavanje...",
        processing: "Izvršavanje...",
        search: "Pretraga:",
        zeroRecords: "Nije pronađen nijedan zapis",
        paginate: {
          first: "Početak",
          last: "Kraj",
          next: "Sljedeća",
          previous: "Nazad",
        },
      },
      ajax: "vozila",
      columns: [
        {
          data: "Brend",
          name: "Brend",
          title: "Naziv vozila",
        },
        {
          data: "OLXID",
          name: "OLXID",
          title: "OLX ID",
        },
        {
          data: "PAID",
          name: "PAID",
          title: "PA ID",
        },
        {
          width: "150px",
          data: "action",
          name: "action",
          title: "",
          orderable: false,
        },
      ],
      createdRow: function (row, data, index) {
        // *********************************************************************
        $("td", row)
          .eq(0)
          .addClass("align-middle")
          ;
    
          $("td", row)
          .eq(1)
          .addClass("align-middle")
          ;
    
          $("td", row)
          .eq(2)
          .addClass("align-middle")
          ;
    
        // Actions
        $("td", row)
          .eq(3)
          .addClass("text-right text-nowrap")
          .html("")
          .append(
            '<a href="exportModelsByCarID/'+data.id+'" class="btn btn-warning user-tooltip" title="Download modela vozila po marki vozila"><i class="fa fa-download"></i></a>&nbsp;&nbsp;'+
            '<a href="vozila/' +
              data.id +
              "/uredi" +
              '" class="btn btn-success btn-sm" title="Uređivanje vozila"><i class="pe-7s-edit" title="Uredi"></i></a>&nbsp;&nbsp;' +
              '<a href="" data-id="' +
              data.id +
              '" data-name="' +
              data.Brend +
              '" class="btn btn-danger btn-sm delete_car" data-toggle="modal" data-target="#delete_car" title="Brisanje vozila"><i class="pe-7s-trash" title="Obriši Vozilo"></i></a>'
          );
      },
    });
});
    