/******/ (function() { // webpackBootstrap
var __webpack_exports__ = {};
/*!************************************************************************!*\
  !*** ./resources/assets/vendor/libs/bootstrap-tagsinput/_extension.js ***!
  \************************************************************************/
// Fix input position calculation
//
var tagsinputBuild = $.fn.tagsinput.Constructor.prototype.build;
var tagsinputDestroy = $.fn.tagsinput.Constructor.prototype.destroy;

$.fn.tagsinput.Constructor.prototype.build = function (options) {
  var _this = this;

  if (options && options.typeahead) {
    $.extend(options.typeahead, {
      minLength: 1,
      afterSelect: function afterSelect() {
        _this.$input[0].value = '';

        _this.$input.data('typeahead').lookup('');
      }
    });
  }

  var result = tagsinputBuild.call(this, options);
  var re = /<|>/g;
  this.$inpWidth = $('<div class="bootstrap-tagsinput-input" style="position:absolute;z-index:-101;top:-9999px;opacity:0;white-space:nowrap;"></div>');
  $('<div style="position:absolute;width:0;height:0;z-index:-100;opacity:0;overflow:hidden;"></div>').append(this.$inpWidth).prependTo(this.$container);

  var getWidth = function getWidth(val) {
    return Math.ceil(_this.$inpWidth.html((val || '').replace(re, '#')).outerWidth() + 12) + 'px';
  };

  this.$input[0].style.width = getWidth();
  this.$input.on('keydown keyup focusout', function () {
    this.style.width = getWidth(this.value);
    if (this.value.length < 1 && options && options.typeahead) $(this).data('typeahead').lookup('');
  });
  this.$input.on('paste', function () {
    setTimeout($.proxy(function () {
      this.style.width = getWidth(this.value);
    }, this), 100);
  });
  return result;
};

$.fn.tagsinput.Constructor.prototype.destroy = function () {
  this.$input.off('keydown keyup focusout paste change');
  return tagsinputDestroy.call(this);
}; // Re-initialize [data-role=tagsinput]


$(function () {
  $('input[data-role=tagsinput], select[multiple][data-role=tagsinput]').tagsinput('destroy');
  $('input[data-role=tagsinput], select[multiple][data-role=tagsinput]').tagsinput();
});
var __webpack_export_target__ = window;
for(var i in __webpack_exports__) __webpack_export_target__[i] = __webpack_exports__[i];
if(__webpack_exports__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ })()
;