/******/ (function() { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/blueimp-gallery/js/blueimp-gallery-video.js":
/*!******************************************************************!*\
  !*** ./node_modules/blueimp-gallery/js/blueimp-gallery-video.js ***!
  \******************************************************************/
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
 * blueimp Gallery Video Factory JS
 * https://github.com/blueimp/Gallery
 *
 * Copyright 2013, Sebastian Tschan
 * https://blueimp.net
 *
 * Licensed under the MIT license:
 * https://opensource.org/licenses/MIT
 */

/* global define */

;(function (factory) {
  'use strict'
  if (true) {
    // Register as an anonymous AMD module:
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(/*! ./blueimp-helper */ "jquery"), __webpack_require__(/*! ./blueimp-gallery */ "./blueimp-gallery")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__))
  } else {}
})(function ($, Gallery) {
  'use strict'

  var galleryPrototype = Gallery.prototype

  $.extend(galleryPrototype.options, {
    // The class for video content elements:
    videoContentClass: 'video-content',
    // The class for video when it is loading:
    videoLoadingClass: 'video-loading',
    // The class for video when it is playing:
    videoPlayingClass: 'video-playing',
    // The class for video content displayed in an iframe:
    videoIframeClass: 'video-iframe',
    // The class for the video cover element:
    videoCoverClass: 'video-cover',
    // The class for the video play control:
    videoPlayClass: 'video-play',
    // Play videos inline by default:
    videoPlaysInline: true,
    // The list object property (or data attribute) for video preload:
    videoPreloadProperty: 'preload',
    // The list object property (or data attribute) for the video poster URL:
    videoPosterProperty: 'poster'
  })

  var handleSlide = galleryPrototype.handleSlide

  $.extend(galleryPrototype, {
    handleSlide: function (oldIndex, newIndex) {
      handleSlide.call(this, oldIndex, newIndex)
      this.setTimeout(function () {
        if (this.activeVideo) {
          this.activeVideo.pause()
        }
      })
    },

    videoFactory: function (obj, callback, videoInterface) {
      var that = this
      var options = this.options
      var videoContainerNode = this.elementPrototype.cloneNode(false)
      var videoContainer = $(videoContainerNode)
      var errorArgs = [
        {
          type: 'error',
          target: videoContainerNode
        }
      ]
      var video = videoInterface || document.createElement('video')
      var coverElement = this.elementPrototype.cloneNode(false)
      var playElement = document.createElement('a')
      var url = this.getItemProperty(obj, options.urlProperty)
      var sources = this.getItemProperty(obj, options.sourcesProperty)
      var title = this.getItemProperty(obj, options.titleProperty)
      var posterUrl = this.getItemProperty(obj, options.videoPosterProperty)
      var playControls = [playElement]
      var hasGalleryControls
      var isLoading
      var i
      videoContainer.addClass(options.videoContentClass)
      $(playElement).addClass(options.videoPlayClass)
      if (
        !$(coverElement)
          .addClass(options.videoCoverClass)
          .hasClass(options.toggleClass)
      ) {
        playControls.push(coverElement)
      }
      coverElement.draggable = false
      if (title) {
        videoContainerNode.title = title
        playElement.setAttribute('aria-label', title)
      }
      if (posterUrl) {
        // Set as background image instead of as poster video element property:
        // - Is accessible for browsers that do not support the video element
        // - Is accessible for both video element and iframe video players
        // - Avoids visual artifacts in IE with the poster property set
        coverElement.style.backgroundImage = 'url("' + posterUrl + '")'
      }
      if (video.setAttribute) {
        if (options.videoPlaysInline) video.setAttribute('playsinline', '')
      } else {
        videoContainer.addClass(options.videoIframeClass)
      }
      video.preload =
        this.getItemProperty(obj, options.videoPreloadProperty) || 'none'
      if (this.support.source && sources) {
        for (i = 0; i < sources.length; i += 1) {
          video.appendChild(
            $.extend(this.sourcePrototype.cloneNode(false), sources[i])
          )
        }
      }
      if (url) video.src = url
      playElement.href = url || (sources && sources.length && sources[0].src)
      if (video.play && video.pause) {
        ;(videoInterface || $(video))
          .on('error', function () {
            that.setTimeout(callback, errorArgs)
          })
          .on('pause', function () {
            if (video.seeking) return
            isLoading = false
            videoContainer
              .removeClass(that.options.videoLoadingClass)
              .removeClass(that.options.videoPlayingClass)
            if (hasGalleryControls) {
              that.container.addClass(that.options.controlsClass)
            }
            video.controls = false
            if (video === that.activeVideo) delete that.activeVideo
            if (that.interval) {
              // Continue slideshow interval
              that.play()
            }
          })
          .on('playing', function () {
            isLoading = false
            coverElement.removeAttribute('style')
            videoContainer
              .removeClass(that.options.videoLoadingClass)
              .addClass(that.options.videoPlayingClass)
          })
          .on('play', function () {
            // Clear slideshow timeout:
            window.clearTimeout(that.timeout)
            isLoading = true
            videoContainer.addClass(that.options.videoLoadingClass)
            if (that.container.hasClass(that.options.controlsClass)) {
              hasGalleryControls = true
              that.container.removeClass(that.options.controlsClass)
            } else {
              hasGalleryControls = false
            }
            video.controls = true
            that.activeVideo = video
          })
        $(playControls).on('click', function (event) {
          that.preventDefault(event)
          that.activeVideo = video
          if (isLoading) {
            video.pause()
          } else {
            video.play()
          }
        })
        videoContainerNode.appendChild(
          (videoInterface && videoInterface.element) || video
        )
      }
      videoContainerNode.appendChild(coverElement)
      videoContainerNode.appendChild(playElement)
      this.setTimeout(callback, [
        {
          type: 'load',
          target: videoContainerNode
        }
      ])
      return videoContainerNode
    }
  })

  return Gallery
})


/***/ }),

/***/ "./blueimp-gallery":
/*!*********************************!*\
  !*** external "blueimpGallery" ***!
  \*********************************/
/***/ (function(module) {

"use strict";
module.exports = window["blueimpGallery"];

/***/ }),

/***/ "jquery":
/*!*************************!*\
  !*** external "jQuery" ***!
  \*************************/
/***/ (function(module) {

"use strict";
module.exports = window["jQuery"];

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	!function() {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = function(module) {
/******/ 			var getter = module && module.__esModule ?
/******/ 				function() { return module['default']; } :
/******/ 				function() { return module; };
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be in strict mode.
!function() {
"use strict";
/*!***********************************************************************!*\
  !*** ./resources/assets/vendor/libs/blueimp-gallery/gallery-video.js ***!
  \***********************************************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var blueimp_gallery_js_blueimp_gallery_video_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! blueimp-gallery/js/blueimp-gallery-video.js */ "./node_modules/blueimp-gallery/js/blueimp-gallery-video.js");
/* harmony import */ var blueimp_gallery_js_blueimp_gallery_video_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(blueimp_gallery_js_blueimp_gallery_video_js__WEBPACK_IMPORTED_MODULE_0__);

}();
var __webpack_export_target__ = window;
for(var i in __webpack_exports__) __webpack_export_target__[i] = __webpack_exports__[i];
if(__webpack_exports__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ })()
;