$(function() {
    var isRtl =
        $("body").attr("dir") === "rtl" || $("html").attr("dir") === "rtl";

    var status = {
        0 : 'Izbrisan',
        1 : 'Aktivan'
    }

    var table = $("#trashed-list").DataTable({
        processing: true,
        serverSide: true,
        info: true,
        ordering: false,
        lengthChange: false,
        pageLength:10,
        order: [[1, "asc"]],
        exportable: true,
        language: {
            emptyTable: "Nema dostupnih podataka u ovoj tablici",
            info: "Prikazano _START_ to _END_ od _TOTAL_ zapisa",
            infoEmpty: "Prikazano 0 to 0 of 0 zapisa",
            infoFiltered: "(filtrirano od _MAX_ ukupnih zapisa)",
            infoPostFix: "",
            thousands: ",",
            lengthMenu: "Prikaži _MENU_ zapisa",
            loadingRecords: "Učitavanje...",
            processing: "Izvršavanje...",
            search: "Pretraga:",
            zeroRecords: "Nije pronađen nijedan zapis",
            paginate: {
                first: "Početak",
                last: "Kraj",
                next: "Sljedeća",
                previous: "Nazad"
            }
        },
        ajax: "deleted",
        columns: [
            {
                width: "25px",
                data: "id",
                name: "id",
                title: 'ID',
                orderable: false
            },
            {
                data: "detail",
                name: "detail",
                title: "Stavka"
            },
            {
                data: "modification",
                name: "modification",
                title: "Modifikacija"
            },
            {
                data: "OLXID",
                name: "OLXID",
                title: "OLX/PIK"
            },
            {
                data: "PAID",
                name: "PAID",
                title: "PA Srbija"
            },
            {
                data: "count_images",
                name: "count_images",
                title: "Broj slika"
            },
            {
                width: "150px",
                data: "action",
                name: "action",
                title: "Akcije",
                orderable: false,
              },
         
        ],
        createdRow: function(row, data, index) {
            
            // *********************************************************************
            $("td", row)
                .eq(0)
                .css('vertical-align', 'top');

            $("td", row)
                .eq(1)
                .css('vertical-align', 'middle')
                .html("")
                .append(
                    data.brend+' '+data.model+' ('+ data.year +' godina) <br/> Kategorija: '
                    +data.category_name+' <br/> Kod: '+data.code_name+ ' <br/> Kreator: '
                    +data.creator+ '<br/> Datum kreiranja: '+data.created_at
                );

            $("td", row)
                .eq(2)
                .css('vertical-align', 'top')
                .html("")
                .append(
                    'Status: '+status[data.active]+' <br/>Moderator: '
                    +data.moderator+'<br/> Datum brisanja: '+data.updated_at
                );
            
            $("td", row)
                .eq(3)
                .css('vertical-align', 'top')
                .html("")
                .append(
                    data.OLXID ? '<span class="badge badge-success"><i class="pe-7s-angle-down"></i></span>' : '<span class="badge badge-danger">X</span>'
                );

            $("td", row)
                .eq(4)
                .css('vertical-align', 'top')
                .html("")
                .append(
                    data.PAID ? '<span class="badge badge-success"><i class="pe-7s-angle-down"></i></span>' : '<span class="badge badge-danger">X</span>'
                );

            $("td", row)
                .eq(5)
                .css('vertical-align', 'top');

            $("td", row)
                .eq(6)
                .css('vertical-align', 'top');

            $("td", row)
                .eq(7)
                .css('vertical-align', 'top');

            $("td", row)
                .eq(8)
                .css('vertical-align', 'top');

            $("td", row)
                .eq(9)
                .css('vertical-align', 'middle');

            $("td", row)
                .eq(10)
                .css('vertical-align', 'middle');

            $("td", row)
                .eq(11)
                .css('vertical-align', 'middle');

            $("td", row)
                .eq(12)
                .css('vertical-align', 'middle');

            $("td", row)
                .eq(13)
                .css('vertical-align', 'middle');

            
        },
      
    });

    $('#search').keyup(function(){
        table.search($(this).val()).draw();
    });

    // SET INITAL VALUE FOR PAGE
    $('#length_change').val(table.page.len());

    // Function change
    $('#length_change').change(function(){
        table.page.len($(this).val()).draw();
    });


});
