$(function() {
    var isRtl =
        $("body").attr("dir") === "rtl" || $("html").attr("dir") === "rtl";

    var table = $("#data-list").DataTable({
        processing: true,
        serverSide: true,
        info: true,
        ordering: false,
        lengthChange: false,
        order: [[1, "asc"]],
        exportable: true,
        language: {
            emptyTable: "Nema dostupnih podataka u ovoj tablici",
            info: "Prikazano _START_ to _END_ od _TOTAL_ zapisa",
            infoEmpty: "Prikazano 0 to 0 of 0 zapisa",
            infoFiltered: "(filtrirano od _MAX_ ukupnih zapisa)",
            infoPostFix: "",
            thousands: ",",
            lengthMenu: "Prikaži _MENU_ zapisa",
            loadingRecords: "Učitavanje...",
            processing: "Izvršavanje...",
            search: "Pretraga:",
            zeroRecords: "Nije pronađen nijedan zapis",
            paginate: {
                first: "Početak",
                last: "Kraj",
                next: "Sljedeća",
                previous: "Nazad"
            }
        },
        ajax: "skladista",
       
        columns: [
         
            {
                data: "Name",
                name: "Name",
                title: "Naziv skladišta"
            },
            {
                width: "150px",
                data: "action",
                name: "action",
                title: "",
                orderable: false
            }
        ],
        createdRow: function(row, data, index) {
            // *********************************************************************

            $("td", row)
                .eq(0)
                .css('vertical-align', 'middle')
                .html("")
                .append(
                    '<a href="skladista/' +
                        data.id +
                        '/" class="" title="Informacije o skladistu">' +
                        data.Name +
                        "</a>"
                );

            // Actions
            $("td", row)
                .eq(1)
                .addClass("text-right text-nowrap")
                .css('vertical-align', 'middle')
                .html("")
                .append(
                    '<a href="" data-id="'+
                        data.id +
                        '" data-name="' +
                        data.Name +
                    '" class="btn btn-success btn-sm update_resource" data-toggle="modal"  data-target="#update_resource" title="Uređivanje skladišta"><i class="pe-7s-edit" title="Uredi"></i></a>&nbsp;&nbsp;' +
                    
                    '<a href="" data-id="' +
                        data.id +
                        '" data-name="' +
                        data.Name +
                        '" class="btn btn-danger delete_resource" data-toggle="modal" data-target="#delete_resource" title="Brisanje mjesta skladištenja"><i class="pe-7s-trash" title="Obriši Vozilo"></i></a>'
                );
        }
    });
    
    $('#search').keyup(function(){
        table.search($(this).val()).draw();
    });

    // SET INITAL VALUE FOR PAGE
    $('#length_change').val(table.page.len());
    
    // Function change
    $('#length_change').change(function(){
        table.page.len($(this).val()).draw();
    });

});
