$(function() {
    var isRtl =
        $("body").attr("dir") === "rtl" || $("html").attr("dir") === "rtl";

    var table = $("#data-list").DataTable({
        processing: true,
        serverSide: true,
        info: true,
        ordering: false,
        lengthChange: false,
        pageLength:10,
        order: [[1, "asc"]],
        exportable: true,
        language: {
            emptyTable: "Nema dostupnih podataka u ovoj tablici",
            info: "Prikazano _START_ to _END_ od _TOTAL_ zapisa",
            infoEmpty: "Prikazano 0 to 0 of 0 zapisa",
            infoFiltered: "(filtrirano od _MAX_ ukupnih zapisa)",
            infoPostFix: "",
            thousands: ",",
            lengthMenu: "Prikaži _MENU_ zapisa",
            loadingRecords: "Učitavanje...",
            processing: "Izvršavanje...",
            search: "Pretraga:",
            zeroRecords: "Nije pronađen nijedan zapis",
            paginate: {
                first: "Početak",
                last: "Kraj",
                next: "Sljedeća",
                previous: "Nazad"
            }
        },
        //ajax: "spareparts/soldedData",
        ajax: {
            url: "spareparts/soldedData",
            data: function(d){
                d.car_id = $('select[name=ccar_id]').val();
                d.hcar_id = $('select[name=hhcar_id]').val();
                d.cat_id = $('select[name=ccat_id]').val();
                d.hcat_id = $('select[name=hhcat_id]').val();
                d.dcar_id = $('select[name=dccar_id]').val();
                if($('#isBooked').prop('checked')){
                    d.isBooked = 1;
                }else{
                    d.isBooked = 0;
                }
            }
        },
        columns: [
            {
                width: "25px",
                data: "id",
                name: "id",
                title: '',
                orderable: false
            },
          
            {
                data: "Brend",
                name: "cars.Brend",
                title: "Marka"
            },
            {
                data: "Model",
                name: "Model",
                title: "Model"
            },
            {
                data: "year",
                name: "year",
                title: "Godina"
            },
            {
                data: "sifra",
                name: "damagedcars.sifra",
                title: "Skinuto sa vozila"
            },
            {
                data: 'Name', 
                name: 'spareparts.Name',
                title: 'Naziv'
            },
           
            {
                data: "CodeName",
                name: "CodeName",
                title: "Kod"
            },

            {
                data: "catalog_number",
                name: "catalog_number",
                title: "Kataloški broj"
            },
   
            {
                data: "category_name",
                name: "categories.category_name",
                title: "Kategorija"
            },
            {
                data: 'sale_date', 
                name: 'spareparts.sale_date', 
                title: 'Datum prodaje'
            },
            {
                data: "param_list",
                name: "param_list",
                title: "Parametri",
                visible:false
            }
        ],
        createdRow: function(row, data, index) {
            // *********************************************************************
            $("td", row)
                .eq(0)
                .css('vertical-align', 'middle')
                .html("")
                .append(
                    '<a href="dijelovi/'+
                    data.id    +
                    '" class=""><i class="fa fa-search"></i></a>'
                );

            $("td", row)
                .eq(1)
                .css('vertical-align', 'middle');

            $("td", row)
                .eq(2)
                .css('vertical-align', 'middle');
            
            $("td", row)
                .eq(3)
                .css('vertical-align', 'middle');

            $("td", row)
                .eq(4)
                .css('vertical-align', 'middle');

            $("td", row)
                .eq(5)
                .css('vertical-align', 'middle')
                .css('font-weight','bold');

            $("td", row)
                .eq(6)
                .css('vertical-align', 'middle')
                .css('font-weight','bold');

            $("td", row)
                .eq(7)
                .css('vertical-align', 'middle');

            $("td", row)
                .eq(8)
                .css('vertical-align', 'middle');

            $("td", row)
                .eq(9)
                .css('vertical-align', 'middle');

            $("td", row)
                .eq(10)
                .css('vertical-align', 'middle');

            $("td", row)
                .eq(11)
                .css('vertical-align', 'middle');

            $("td", row)
                .eq(12)
                .css('vertical-align', 'middle');

            $("td", row)
                .eq(13)
                .css('vertical-align', 'middle');

            
        },
       

    });

    $('#search').keyup(function(){
        table.search($(this).val()).draw();
    });

    // SET INITAL VALUE FOR PAGE
    $('#length_change').val(table.page.len());

    // Function change
    $('#length_change').change(function(){
        table.page.len($(this).val()).draw();
    });

    
    $('#cars2').change(function(){
        table.draw();
    });

    $('#categories2').change(function(){
        table.draw();
    });

    $('#damagedcars2').change(function(){
        table.draw();
    });

    $("#isBooked").change(function(){
        table.draw();
    });

});
