$(function() {
    var isRtl =
        $("body").attr("dir") === "rtl" || $("html").attr("dir") === "rtl";

    var table = $("#spareparts-list").DataTable({
        processing: true,
        serverSide: true,
        info: true,
        ordering: false,
        lengthChange: false,
        pageLength:10,
        order: [[1, "asc"]],
        exportable: true,
        language: {
            emptyTable: "Nema dostupnih podataka u ovoj tablici",
            info: "Prikazano _START_ to _END_ od _TOTAL_ zapisa",
            infoEmpty: "Prikazano 0 to 0 of 0 zapisa",
            infoFiltered: "(filtrirano od _MAX_ ukupnih zapisa)",
            infoPostFix: "",
            thousands: ",",
            lengthMenu: "Prikaži _MENU_ zapisa",
            loadingRecords: "Učitavanje...",
            processing: "Izvršavanje...",
            search: "Pretraga:",
            zeroRecords: "Nije pronađen nijedan zapis",
            paginate: {
                first: "Početak",
                last: "Kraj",
                next: "Sljedeća",
                previous: "Nazad"
            }
        },
        //ajax: "parts/data",
        ajax: {
            url: "http://localhost/skladista/palac/rastavljenavozila/4/parts/data",
            //url: "http://skladiste.autokuca-mativ.com/klijenti/1/detalji/data",
            data: function(d){
                d.damagedcar_id = $('#ddamagedcar_id').val();
                d.category_id = $('select[name=category_id]').val();
            }
        },
        columns: [
            {
                width: "25px",
                data: "id",
                name: "id",
                title: '',
                orderable: false
            },
            {
                data: 'name', 
                name: 'spareparts.name',
                title: 'Serijski broj'
            },
            {
                data: "code_name",
                name: "code_name",
                title: "Kod"
            },
            {
                data: "category_name",
                name: "categories.category_name",
                title: "Kategorija"
            },
            {
                data: "remark",
                name: "Remark",
                title: "Napomena"
            },
            {
                data: "prodano",
                name: "prodano",
                title: "Status"
            },
    
            {
                data: "param_list",
                name: "param_list",
                title: "Parametri",
                visible:false
            }
        ],
        createdRow: function(row, data, index) {
            if (data.status === 0) {
                $(row).css("background-color", "rgb(230, 240, 221, 100%)");
          
            }
            // *********************************************************************
            $("td", row)
                .eq(0)
                .css('vertical-align', 'middle')
                .html("")
                .append(
                    '<a href="dijelovi/'+
                    data.id    +
                    '" class=""><i class="fa fa-search"></i></a>'
                );

            $("td", row)
                .eq(1)
                .css('vertical-align', 'middle');

            $("td", row)
                .eq(2)
                .css('vertical-align', 'middle');
            
            $("td", row)
                .eq(3)
                .css('vertical-align', 'middle');

            $("td", row)
                .eq(4)
                .css('vertical-align', 'middle');

            $("td", row)
                .eq(5)
                .css('vertical-align', 'middle');

            $("td", row)
                .eq(6)
                .css('vertical-align', 'middle');

            $("td", row)
                .eq(7)
                .css('vertical-align', 'middle');

            $("td", row)
                .eq(8)
                .css('vertical-align', 'middle');

            $("td", row)
                .eq(9)
                .css('vertical-align', 'middle');

            $("td", row)
                .eq(10)
                .css('vertical-align', 'middle');

            $("td", row)
                .eq(11)
                .css('vertical-align', 'middle');

            $("td", row)
                .eq(12)
                .css('vertical-align', 'middle');

            $("td", row)
                .eq(13)
                .css('vertical-align', 'middle');

            
        },

    });

    $('#search').keyup(function(){
        table.search($(this).val()).draw();
    });

    // SET INITAL VALUE FOR PAGE
    $('#length_change').val(table.page.len());

    // Function change
    $('#length_change').change(function(){
        table.page.len($(this).val()).draw();
    });

    
    $('#cars_2').change(function(){
        table.draw();
    });

    $('#categories').change(function(){
        table.draw();
    });

    $('#damagedcars').change(function(){
        table.draw();
    });

});
