$(function() {
    var isRtl =
        $("body").attr("dir") === "rtl" || $("html").attr("dir") === "rtl";

    var table = $("#data-list").DataTable({
        processing: true,
        serverSide: true,
        info: true,
        ordering: false,
        lengthChange: false,
        pageLength:10,
        order: [[1, "asc"]],
        exportable: true,
        language: {
            emptyTable: "Nema dostupnih podataka u ovoj tablici",
            info: "Prikazano _START_ to _END_ od _TOTAL_ zapisa",
            infoEmpty: "Prikazano 0 to 0 of 0 zapisa",
            infoFiltered: "(filtrirano od _MAX_ ukupnih zapisa)",
            infoPostFix: "",
            thousands: ",",
            lengthMenu: "Prikaži _MENU_ zapisa",
            loadingRecords: "Učitavanje...",
            processing: "Izvršavanje...",
            search: "Pretraga:",
            zeroRecords: "Nije pronađen nijedan zapis",
            paginate: {
                first: "Početak",
                last: "Kraj",
                next: "Sljedeća",
                previous: "Nazad"
            }
        },
        //ajax: "http://localhost/autocentarcven/public/klijenti/1/detalji/data",
        ajax: {
            url: "http://localhost/skladista/mativ/klijenti/1/detalji/data",
            //url: "http://skladiste.autokuca-mativ.com/klijenti/1/detalji/data",
            data: function(d){
                d.client_id = $('#client_id').val();
                if($('#isPaid').prop('checked')){
                    d.isPaid = 1;
                }else{
                    d.isPaid = 0;
                }
            }
        },
        columns: [
            {
                width: "10px",
                data: "action",
                name: "action",
                title: "",
                orderable: false
            },
            {
                data: "name",
                name: "name",
                title: "Naziv dijela"
            },
            {
                data: "remark",
                name: "remark",
                title: "Napomena"
            },
            {
                data: "price",
                name: "price",
                title: "Cijena"
            }
           
        ],

        createdRow: function(row, data, index) {
            // *********************************************************************
            if (data.isPaid === 1) {
                $(row).css("background-color", "rgb(230, 240, 221, 100%)");
          
            }

            // Actions
            $("td", row)
               .eq(0)
               .css('vertical-align', 'middle');

           

            $("td", row)
                .eq(1)
                .css('vertical-align', 'middle');
                
            $("td", row)
                .eq(2)
                .css('vertical-align', 'middle');
            
            $("td", row)
                .eq(3)
                .css('vertical-align', 'middle');

        },
        footerCallback: function (row, data, start, end, display) {
            var api = this.api();
 
            // Remove the formatting to get integer data for summation
            var intVal = function (i) {
                return typeof i === 'string' ? i.replace(/[\$,]/g, '') * 1 : typeof i === 'number' ? i : 0;
            };
 
            // Total over all pages
            total = api
                .column(3)
                .data()
                .reduce(function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0);
 
            // Total over this page
            pageTotal = api
                .column(3, { page: 'current' })
                .data()
                .reduce(function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0);

          
            
            // Update footer
            $(api.column(2).footer()).html('Ukupno');
            $(api.column(3).footer()).html(total+'KM');
          
            
        },
    });

    $('#isPaid').change(function(){
        table.draw();
    });

    $('#search').keyup(function(){
        table.search($(this).val()).draw();
      });
  
    // SET INITAL VALUE FOR PAGE
    $('#length_change').val(table.page.len());

    // Function change
    $('#length_change').change(function(){
        table.page.len($(this).val()).draw();
    });
});
