$(function () {

  var table = $("#data-list").DataTable({
     processing: true,
     serverSide: true,
     info: true,
     ordering: false,
     lengthChange: false,
     pageLength:10,
     order: [[1, "asc"]],
     exportable: true,
     language: {
       emptyTable: "Nema dostupnih podataka u ovoj tablici",
       info: "Prikazano _START_ to _END_ od _TOTAL_ zapisa",
       infoEmpty: "Prikazano 0 to 0 of 0 zapisa",
       infoFiltered: "(filtrirano od _MAX_ ukupnih zapisa)",
       infoPostFix: "",
       thousands: ",",
       lengthMenu: "Prikaži _MENU_ zapisa",
       loadingRecords: "Učitavanje...",
       processing: "Izvršavanje...",
       search: "Pretraga:",
       zeroRecords: "Nije pronađen nijedan zapis",
       paginate: {
         first: "Početak",
         last: "Kraj",
         next: "Sljedeća",
         previous: "Nazad",
       },
     },
     ajax: "vozila",
     columns: [
       {
         data: "Brend",
         name: "Brend",
         title: "Naziv vozila",
       },
   
       {
         width: "150px",
         data: "action",
         name: "action",
         title: "",
         orderable: false,
       },
     ],
     createdRow: function (row, data, index) {
       // *********************************************************************
       $("td", row)
         .eq(0)
         .css('vertical-align', 'middle');
 
       // Actions
       $("td", row)
         .eq(1)
         .addClass("text-right text-nowrap")
         .css('vertical-align', 'middle')
         .html("")
         .append(
             '<a href="" data-id="' +
                 data.id +
             '" data-name="' +
                 data.Brend +
             '" class="btn btn-success btn-sm update_resource" data-toggle="modal"  data-target="#update_resource" title="Uređivanje vozila"><i class="pe-7s-edit" title="Uredi"></i></a>&nbsp;&nbsp;' +

             '<a href="" data-id="' +
                 data.id +
                 '" data-name="' +
                 data.Brend +
                 '" class="btn btn-danger user-tooltip delete_resource" data-toggle="modal" data-target="#delete_resource" title="Brisanje vozilaa"><i class="pe-7s-trash" title="Obriši parametar"></i></a>'
         );
     },
   });
   
   $('#search').keyup(function(){
     table.search($(this).val()).draw();
   });

   // SET INITAL VALUE FOR PAGE
   $('#length_change').val(table.page.len());

   // Function change
   $('#length_change').change(function(){
     table.page.len($(this).val()).draw();
   });
});
 